define([
    'underscore',
    'backbone',
    'marionette',
    'text!modules/loading-spinner/loading.html',
    'text!modules/loading-spinner/cancellation.html',
], function(
    _,
    Backbone,
    Marionette,
    LoadingTemplate,
    CancellationTemplate
) {
    'use strict';

    var _loadingSpinner = {
        radio: Backbone.Radio.channel('spinner'),
        options: {withMask: true},
        _isShowing: false,
        template: LoadingTemplate,
    };

    _loadingSpinner.setOption = function setOption(option, value) {
        _loadingSpinner[option] = value;
    };
    _loadingSpinner.setOptions = function setOptions(options) {
        $.extend(this.options, options);
    };

    _loadingSpinner.setTemplateForLoadingOverlay = function setTemplateForLoadingOverlay(target) {
        var showLoadingMessage = $(target).find('#cancel-booked-appointment-btn').length === 0;
        var template = _.template(showLoadingMessage ? LoadingTemplate : CancellationTemplate);
        _loadingSpinner.setOption('template', template);
    };

    _loadingSpinner.register = function register(options) {
        var showLoader;
        var hideLoader;

        _loadingSpinner.setOptions(options);

        showLoader = function() {
            if ($.active > 0 && !_loadingSpinner._isShowing) {
                _loadingSpinner.show();
                _loadingSpinner.radio.trigger('show');
            }
        };
        hideLoader = function () {
            if ($.active > 0 && !_loadingSpinner._isShowing) {
                showLoader();
            } else if ($.active === 0) {
                _loadingSpinner.hide();
                _loadingSpinner.radio.trigger('hide');
            }
        };

        $(window.document)
            .ajaxSend(function(e) {
                _loadingSpinner.setTemplateForLoadingOverlay(e.target);
                showLoader();
            })
            .ajaxComplete(function(e) {
                _loadingSpinner.setTemplateForLoadingOverlay(e.target);
                hideLoader();
            })
            .ajaxStop(function(e) {
                _loadingSpinner.setTemplateForLoadingOverlay(e.target);
                hideLoader();
            });
    };

    _loadingSpinner.show = function() {

        if (this.options.withMask) {
            $('body').append('<div class="loaderModalMask"/>');
        }
        $.mobile.loading('show', {
            html: _loadingSpinner.template,
            textVisible: true,
            theme: 'a',
        });

        $('.loading-header').focus();

        _loadingSpinner._isShowing = true;
    };

    _loadingSpinner.hide = function() {
        $('.loaderModalMask').remove();
        $.mobile.loading('hide');

        _loadingSpinner._isShowing = false;
    };

    return _loadingSpinner;
});
